#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA口配置输出
	TRISB = 0X00;   //PB口配置输出
	
	PORTA = 0X00;	  //PORTA输出低
	PORTB = 0X00;	  //PORTB输出低
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关闭PA开漏
	PBOD = 0X00;    //关闭PB开漏
	
	ANASEL0 = 0X00; //关闭PA模拟通道
	ANASEL1 = 0X00; //关闭PB模拟通道
}
/*******************************************************************************
* Description    : ADC初始化
* Input          : None
* Output         : None
* Return         : None
* Attention	     : 默认采集FVR 1.0V ->反推VCC电压
*******************************************************************************/
void ADC_Exce(void)
{
	unsigned short  timeout; 
   
	GO  = 1;  		//start ADC

	//等待AD转换结束
	timeout = 0;
	while(GO)
	{
		CLRWDT();		
		timeout++;
		if(timeout > 2000)
		{
			ADON = 0;
			GO  = 0;
			ADON = 1;
			GO  = 1;
			
			break;
		}
	}
}

/*

*/
void ADC_Config(void)
{
	ADCON0 = 0X21;  //配置FVROUT为ADC采集通道，使能A/D模拟使能位;
	ADCON1 = 0XBC;  //参考电压选择VDD，A/D转换时钟选择FOSC/64(ADSP=1)
}

void fvr_int(void)
{
	FVRCON0 = 0X21;//使能FVR，不放大，选择VREF1P0(1.0V)通道
}
